#ifndef __WIN_SOCKET_H_
#define __WIN_SOCKET_H_

namespace CPPMUD
{
	#ifdef _WIN32
	// Windows
	#if _MSC_VER > 1000
	#pragma once
	#endif

	class CWinSocket : public CServerSocket
	{
	public:
		// Constructor & Deconstructor
		CWinSocket();
		virtual ~CWinSocket();

		// Public Accessor Functions

		// Public Functions
		virtual ErrRet CloseClient(int nClientID);
		virtual ErrRet CloseSockets();
		virtual ErrRet Connect(int nPort);
		virtual ErrRet InitSockets();
		virtual ErrRet Listen(int nPort);
		virtual ErrRet ReadData(char *czData, int nBufferSize, int nClientID);
		virtual void NonBlocking(SOCKET sSocket);

		// Public Variables

	protected:
		// Protected Functions
		virtual ErrRet CloseSocket(SOCKET sSocket);
		virtual ErrRet SendData(int nClientID);

		// Protected Variables
		WSADATA m_wsaData;
	};

	#endif
};

#endif